<?php

namespace AppBundle\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * PosterRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class PosterRepository extends EntityRepository
{
		/****
	returns the number of entity's rows
	@return int
	*/
	public function notSlug() {
		$query = $this->createQueryBuilder('p')->select('p')->where("p.id = p.slug")->getQuery();
		return $query->execute();
	}
	public function countMovies() {
		$query = $this->createQueryBuilder('e')->select('count(e)')->where("e.type like 'movie'")->getQuery();
		return $query->getSingleScalarResult();
	}
	public function countSeries() {
		$query = $this->createQueryBuilder('e')->select('count(e)')->where("e.type like 'serie'")->getQuery();
		return $query->getSingleScalarResult();
	}
	public function countMoviesDownloads() {
		$query = $this->createQueryBuilder('e')->select('sum(e.downloads)')->where("e.type like 'movie'")->getQuery();
		return $query->getSingleScalarResult();
	}
	public function countMoviesShares() {
		$query = $this->createQueryBuilder('e')->select('sum(e.shares)')->where("e.type like 'movie'")->getQuery();
		return $query->getSingleScalarResult();
	}
	public function countMoviesViews() {
		$query = $this->createQueryBuilder('e')->select('sum(e.views)')->where("e.type like 'movie'")->getQuery();
		return $query->getSingleScalarResult();
	}
	public function countSeriesDownloads() {
		$query = $this->createQueryBuilder('e')->select('sum(e.downloads)')->where("e.type like 'serie'")->getQuery();
		return $query->getSingleScalarResult();
	}
	public function countSeriesShares() {
		$query = $this->createQueryBuilder('e')->select('sum(e.shares)')->where("e.type like 'serie'")->getQuery();
		return $query->getSingleScalarResult();
	}
	public function countSeriesViews() {
		$query = $this->createQueryBuilder('e')->select('sum(e.views)')->where("e.type like 'serie'")->getQuery();
		return $query->getSingleScalarResult();
	}

}
